/* types.h */

typedef enum {

	kind_fndef, kind_fndefint, kind_fndefext, kind_constant,
	kind_assign, kind_list, kind_call, kind_array,

	op_plus, op_minus, op_times, op_divide,
	op_gt, op_lt, op_ge, op_le, op_eq, op_ne,
	op_and, op_or,

	stmt_if, stmt_while, stmt_switch, stmt_casenum, stmt_casevar,
	stmt_break, stmt_default, stmt_return

} ast_kind;

typedef struct ast {
	enum {
		int_ast, real_ast, var_ast, casenum_ast, casevar_ast,
		str_ast, node_ast, array_ast
 	} tag;
	union {
		long	integer;
		float	real;
		char*	variable;
		char*	string;
		struct {
			ast_kind		tag;
			struct ast_list*	head;
		} node;
	} info;
} ast;

typedef struct ast_list { 
	ast*             elem;
	struct ast_list* next;
} ast_list;
