/* config.h */

#ifndef __CONFIG_H
#define __CONFIG_H

#include "types.h"

#define CONFIG_VERSION 0
#define CONFIG_MAGIC 0xc07f18

struct config {
    struct {
	pid_params rollpitch;
	pid_params yaw;
    } pid;
    struct {
	struct {
	    stick_timing x, y, z, throttle;
	} timing;
	struct {
	    stick_sensitivity x, y, z;
	} sensitivity;
    } stick;
    struct {
	unsigned int gyro_sensitivity;
	unsigned int accel_sensitivity;
    } mpu6050;
    /*   Magnetometer calibration */
};

extern struct config config;
extern bool config_valid;

void config_init(char *buffer);

#endif /* __CONFIG_H */
