/* log.h */

#ifndef __LOG_H
#define __LOG_H

#include "types.h"

char log_get_byte(void);
void log_put_byte(char c);
void log_put_uint16(unsigned int i);
void log_put_uint(unsigned int i);
void log_put_float(float f);
void log_put_header(unsigned int timestamp);
void log_put_array(char *data, int length);
void log_put_config(void);

void log_mark_busy(void);
void log_mark_idle(void);
unsigned int log_read_busytime(void);

/* Needed by log.c and sdcard.c only */
#define LOG_MAGIC 0x00000CFC
#define LOG_MAGIC_CONFIG 0x00C07F18

#define LOG_BUFFERSIZE 4096

extern unsigned int log_bufferstart;
extern unsigned int log_bufferend;
extern bool log_enabled;
extern char log_buffer[];

extern unsigned int log_generation;

#define LOG_BUFFER_EMPTY (log_bufferstart == log_bufferend)
#define LOG_BUFFER_BYTES ((log_bufferend - log_bufferstart) % \
                                LOG_BUFFERSIZE)

#endif /* __LOG_H */
