/* config.c */

#include "types.h"
#include "config.h"
#include "crc.h"
#include "log.h"
#include "status.h"
#include "panic.h"

struct config config;

bool config_valid = FALSE;

#define READ_UINT(b, i) ((b)[(i)] + ((b)[(i)+1] << 8) + \
                ((b)[(i)+2] << 16) + ((b)[(i)+3] << 24))

unsigned int foobar = sizeof(struct config);

void config_init(char *buffer)
{
    config_valid = FALSE;
    if (READ_UINT(buffer, 0) == CONFIG_MAGIC) {
	if (READ_UINT(buffer, 4) == CONFIG_VERSION) {
	    if (check_crc(buffer, sizeof(struct config)+12)) {
		config = *(struct config *)(buffer+8);
		config_valid = TRUE;
	    }
	}
    }
    if (config_valid) {
	log_put_config();
	status_set_ready(STATUS_MODULE_CONFIG, TRUE);
    }
}

