#ifndef __INTERRUPT_H
#define __INTERRUPT_H

#define VICVectAddr (*(volatile unsigned int *)0xFFFFF030)

#define I_WDT		0

#define I_ARMCore0	2
#define I_ARMCore1	3
#define I_TIMER0	4
#define I_TIMER1	5
#define I_UART0		6
#define I_UART1		7

#define I_I2C0		9
#define I_SPI0		10
#define I_SPI1		11
#define I_SSP		11
#define I_PLL		12
#define I_RTC		13
#define I_EINT0		14
#define I_EINT1		15
#define I_EINT2		16

#define I_AD0		18
#define I_I2C1		19

#define I_TIMER2	26
#define I_TIMER3	27

/* Assign interrupt priorities here to avoid clashes */

#define I_PRIORITY_I2C0		0
#define I_PRIORITY_UART0	1
#define I_PRIORITY_TIMER0	2

#define interrupt_clear() do { VICVectAddr = 0xff; } while (0)

void init_interrupt(void);
void interrupt_register_code(unsigned int source, unsigned int priority,
			void(*handler)(void));

#define interrupt_register(x, fn) \
	interrupt_register_code(I_##x, I_PRIORITY_##x, fn)

#endif /* __INTERRUPT_H */
