/* led.c */

#include "led.h"
#include "timer.h"

#define FP0XVAL (*((volatile unsigned int *) 0x3FFFC014))

led_pattern *led_current_pattern;
led_pattern *led_current_pointer;
unsigned int led_next_time;
bool led_next_state;

led_pattern led_pattern_active[] = {250, 250, 0};
led_pattern led_pattern_unknown[] = {100, 100, 0};

void led_set(bool on)
{
	if (on)
		FP0XVAL &= ~0x04000000;
	else
		FP0XVAL |= 0x04000000;
}

void led_update(void)
{
	unsigned int time = timer_read();

	/* This should never be possible, but let's just be sure. */
	if (!led_current_pattern)
		return;
	if (!led_current_pointer)
		return;

	if (((signed int) (((signed int)led_next_time)-time)) > 0)
		return;

	led_set(led_next_state);
	led_next_state = !led_next_state;
	led_next_time += *led_current_pointer * TIMER0_MS;
	led_current_pointer++;
	if (*led_current_pointer == 0)
		led_current_pointer = led_current_pattern;
}

void led_set_pattern(led_pattern *pattern)
{
	if (led_current_pattern == pattern)
		return;
	led_current_pattern = pattern;
}

void led_init(void)
{
	led_current_pattern = led_pattern_unknown;
	led_current_pointer = led_pattern_unknown;
	led_next_state = TRUE;
	led_next_time = timer_read();
	led_update();
}
