#ifndef __UART_H
#define __UART_H

#include "types.h"

#ifdef USE_UART
void init_uart(void);
void putch(char c);
void putstr(char *s);
void putint(unsigned int n);
void putint_s(int n);
void puthex(unsigned int n);
bool getch(char *c);
#else
#define init_uart() ((void)0)
#define putch(x) ((void)0)
#define putstr(x) ((void)0)
#define putint(x) ((void)0)
#define putint_s(x) ((void)0)
#define puthex(x) ((void)0)
#define getch(x) (FALSE)
#endif

#endif /* __UART_H */
