#ifndef __TIMER_H
#define __TIMER_H

#define TIMER_PCLK 14745600
#define TIMER_PRESCALE 0

#define TIMER_SECOND (TIMER_PCLK/(TIMER_PRESCALE+1))
#define TIMER_MS (TIMER_SECOND/1000)
#define TIMER_US (TIMER_SECOND/1000000)

void init_timer(void);
unsigned int timer_read(void);
void timer_delay_clocks(unsigned int clocks);

#define timer_delay_us(x) timer_delay_clocks((x)*TIMER_US)
#define timer_delay_ms(x) timer_delay_clocks((x)*TIMER_MS)

#endif /* __TIMER_H */
