/* plugins.c */

/*
 * This is the master table of plugins. Add a plugin here
 * for it to take effect.
 */

#include "plugin.h"

#include "midi.h"
#include "dmx.h"
#include "beatdetect.h"
#include "mouse.h"

struct plugin plugins_table[] = {
	{"midi", midi_init, midi_close, 0},
	{"dmx", dmx_init, dmx_close, 0},
	{"beatdetect", beatdetect_init, beatdetect_close, 0},
	{"mouse", mouse_init, mouse_close, 0},
};

int nplugins = (sizeof(plugins_table) / sizeof(struct plugin));

