/* hash.h */

/*
 * Declare hash as:
 *   struct hashentry *hash[HASHSIZE];
 *
 * Initialise with hash_init(hash);
 * free all hash items with hash_clear(hash);
 *
 */

struct hashentry {
	char *name;
	int value;
	int flags;
	struct hashentry *next;
};

#define HASHSIZE 512
#define HASHMASK (HASHSIZE - 1)

typedef void (*hash_action)(struct hashentry *);

int hashfn(char *);
void hash_iterate(struct hashentry **, hash_action);
void hash_clear(struct hashentry **);
void hash_init(struct hashentry **);

/*
 * hash_lookup - lookup item in the hash
 *
 * The action on failure is determined by arg 3. If non-zero,
 * then a hash entry will be created and returned. Otherwise,
 * NULL is returned. If a new item is created, the name field
 * will be NULL, and it is the responsibility of the caller
 * to fill this in correctly.
 */
struct hashentry *hash_lookup(struct hashentry **, char *, int);

