#ifndef __TIMER_H
#define __TIMER_H

#include "types.h"

#define TIMER_PCLK 14745600
#define TIMER_PRESCALE 0

#define TIMER_SECOND (TIMER_PCLK/(TIMER_PRESCALE+1))
#define TIMER_MS (TIMER_SECOND/1000)
#define TIMER_US (TIMER_SECOND/1000000)

#define PWM_MAX 14745
#if 0
#define PWM_PERIOD 58980
#endif
#define PWM_PERIOD ((4*PWM_MAX)+1)

#define TIMER_INPUT_TIMEOUT (TIMER_PCLK/10)
#define TIMER_CPPM_SYNC 40000

#define TIMER_CH(x) (timer_map[x])

extern volatile unsigned int timer1_width[];
extern volatile unsigned int timer1_cppm[];
extern unsigned int timer_map[];

void init_timer(void);
unsigned int timer_read(void);
void timer_delay_clocks(unsigned int clocks);
void timer_set_period(unsigned int period);
void timer_set_pwm_value(int channel, int value);
void timer_set_pwm_invalid(int channel);
bool timer_valid(int channel);
bool timer_allvalid(void);

#define timer_delay_us(x) timer_delay_clocks((x)*TIMER_US)
#define timer_delay_ms(x) timer_delay_clocks((x)*TIMER_MS)

#ifdef TIMER_CPPM
#define timer_input(ch) (timer1_cppm[TIMER_CH(ch)])
#else
#define timer_input(ch) (timer1_width[TIMER_CH(ch)])
#endif
#endif /* __TIMER_H */
