#include "uart.h"

#define UARTBASE 0xE000C000

#define RBR 0x00
#define THR 0x00
#define DLL 0x00
#define DLM 0x04
#define IER 0x04
#define IIR 0x08
#define FCR 0x08

#define LCR 0x0c
#define LSR 0x14
#define SCR 0x1c
#define ACR 0x20
#define FDR 0x28
#define TER 0x30

#define UREG(x) (((volatile unsigned char *)UARTBASE)[x])

#define U0THRE ((UREG(LSR) & (1<<5))) /* UART0 transmitter holding register is empty */
#define U0DR ((UREG(LSR) & (1<<0))) /* UART0 data ready */

void init_uart(void)
{
	UREG(FDR) = 0x10; /* DivAddVal = 0, MulVal = 1 */

	UREG(LCR) = 0x80;
	UREG(DLM) = 0x00;
	UREG(DLL) = 0x08; /* 14745600 / (16*115200) */
	UREG(LCR) = 0x13;
	UREG(FCR) = 0x07;
}

void putch(char c) {
	while (!U0THRE);
	UREG(THR) = c;
}

void putstr(char *s) {
	while (*s) putch(*s++);
}

void putint(unsigned int n) {
	char s[11];
	int i;

	i = 10;
	s[i] = '\0';

	do {
		s[--i] = n % 10 + '0';
	} while ((n /= 10) > 0);

	putstr(s+i);
}

void puthex(unsigned int n) {
	char s[9];
	int i;

	i = 8;
	s[i] = '\0';

	do {
		int x = n % 16;
		if (x > 9)
			x += 'A' - '0' - 10;
		s[--i] = x + '0';
	} while ((n /= 16) > 0);

	putstr(s+i);
}

char getch(void) {
	while (!U0DR);
	return UREG(RBR);
}
