/* matrix.h */

/* dest[r][c] = m1[r][n] * m2[n][c] */
void matrix_multiply(float *dest, float *m1, float *m2, int r, int c, int n);

/* dest[r][c] = m1[r][n] * m2[c][n] */
void matrix_multiply_t(float *dest, float *m1, float *m2, int r, int c, int n);

/* dest[r][c] = m1[r][c] + m2[r][c] */
void matrix_add(float *dest, float *m1, float *m2, int r, int c);

#ifdef MATRIX_DEBUG
void dump_matrix(float *m, int r, int c);
#endif

/* Invert src into dst.
 * NOTE: destroys the src matrix
 */
void matrix_invert(float *dst, float *src, int size);
