#include "timer.h"

#define TIMER0BASE  0xE0004000
#define TIMER1BASE  0xE0008000

#define IR    0x00
#define TCR   0x04
#define TC    0x08
#define PR    0x0c
#define PC    0x10
#define MCR   0x14
#define MR0   0x18
#define MR1   0x1C
#define MR2   0x20
#define MR3   0x24
#define CCR   0x28
#define CR0   0x2C
#define CR1   0x30
#define CR2   0x34
#define CR3   0x38
#define EMR   0x3C
#define CTCR  0x70
#define PWM   0x74

#define TREG(x) (((volatile unsigned char *)TIMER0BASE)[x])
#define TWREG(x) (((volatile unsigned int *)TIMER0BASE)[(x)/sizeof(unsigned int)])

#define TCR_ENABLE (1<<0)
#define TCR_RESET  (1<<1)

void init_timer(void)
{
	TREG(TCR) = TCR_ENABLE | TCR_RESET;

	TREG(CTCR) = 0; /* Use PCLK */
	TREG(TC) = 0;
	TREG(PR) = TIMER_PRESCALE ;
	TREG(PC) = 0;

	TREG(TCR) = TCR_ENABLE;
}

unsigned int timer_read(void)
{
	return TWREG(TC);
}

void timer_delay_clocks(unsigned int clocks)
{
	signed int time = TWREG(TC) + clocks;
	while (((signed int) (time-TWREG(TC))) > 0);
}

