/* status.h */

#include "types.h"

bool status_armed(void);
void status_set_ready(unsigned int module, bool ready);
void status_set_led_pattern(unsigned int module);
void init_status(void);


#define STATUS_MODULE_GYRO_ZERO 0
#define STATUS_MODULE_GYRO_RATE 1
#define STATUS_MODULE_ATTITUDE  2
#define STATUS_MODULE_DCM_ERROR 3
#define STATUS_MODULE_STICK     4

#define STATUS_MODULES		5

#define STATUS_COUNT {				\
		STATUS_COUNT_GYRO_ZERO,		\
		STATUS_COUNT_GYRO_RATE,		\
		STATUS_COUNT_ATTITUDE,		\
		STATUS_COUNT_DCM_ERROR,		\
		STATUS_COUNT_STICK		\
	}

/*
 * Each condition must be valid for so many samples, typically once
 * per 100Hz loop
 */
#define STATUS_COUNT_STICK     100
#define STATUS_COUNT_GYRO_ZERO 1
#define STATUS_COUNT_GYRO_RATE 100
#define STATUS_COUNT_ATTITUDE  100
#define STATUS_COUNT_DCM_ERROR 100

