
#define UARTBASE 0xE000C000

#define RBR 0x00
#define THR 0x00
#define DLL 0x00
#define DLM 0x04
#define IER 0x04
#define IIR 0x08
#define FCR 0x08

#define LCR 0x0c
#define LSR 0x14
#define SCR 0x1c
#define ACR 0x20
#define FDR 0x28
#define TER 0x30

#define REG(x) (((volatile unsigned char *)UARTBASE)[x])

#define U0THRE ((REG(LSR) & (1<<5))) /* UART0 transmitter holding register is empty */
#define U0DR ((REG(LSR) & (1<<0))) /* UART0 data ready */

#define PINSEL0 (*((volatile unsigned char *) 0xE002C000))

void init_uart(void)
{
	REG(FDR) = 0x10; /* DivAddVal = 0, MulVal = 1 */

	REG(LCR) = 0x80;
	REG(DLM) = 0x00;
	REG(DLL) = 0x08; /* 14745600 / (16*115200) */
	REG(LCR) = 0x13;
	REG(FCR) = 0x07;

	PINSEL0 = 0x00000005; /* P0.0 and P0.1 assigned to UART */
}

void putch(char c) {
	while (!U0THRE);
	REG(THR) = c;
}

void putstr(char *s) {
	while (*s) putch(*s++);
}

void putint(unsigned int n) {
	char s[11];
	int i;

	i = 10;
	s[i] = '\0';

	do {
		s[--i] = n % 10 + '0';
	} while ((n /= 10) > 0);

	putstr(s+i);
}

char getch(void) {
	while (!U0DR);
	return REG(RBR);
}

void reply(char *str)
{
	putstr(str);
	putstr("\r\n");
}

unsigned int count = 0;

int main(void) {
	init_uart();
	putstr("Your entire life has been a mathematical error... a mathematical error I'm about to correct!\r\n");

	while (1) {
		char c;
		putstr("prompt> ");
		c = getch();
		if (c == 0x0a)
			continue;
		putch(c);
		putstr("\r\n");
		switch (c & 0xdf) {
		case 0x0a:
		case 0x0d:
			break;
		case 'A':
			reply("apple");
			break;
		case 'C':
			count++;
			putstr("The current count is ");
			putint(count);
			reply(".");
			break;
		case 'H':
		case '?':
			reply("Help is not available. Try a psychiatrist.");
			break;
		default:
			reply("Unrecognised command.");
			break;
		}
	}

	return 0;
}
