/* Implementation of fast inverse square root.
 * See http://en.wikipedia.org/wiki/Fast_inverse_square_root
 */

float fisqrt(float n)
{
	long i;
	float x2, y;

	x2 = n * 0.5f;
	y = n;
	i = *(long *)&y;
	i = 0x5f3759df - (i>>1);
	y = *(float *)&i;
	y = y * (1.5f - (x2*y*y));

	return y;
}
