/* panic.c */

/*
 * Something has gone horribly, horribly wrong.
 *
 * If we are in the air, we are going to crash. This could be nasty.
 * Try to limit the damage by turning off all of the motors.
 * There's not much else we can do at this point.
 *
 */

#include "panic.h"
#include "motor.h"
#include "led.h"

led_pattern led_pattern_panic[] = {100, 100, 100, 100, 100, 100, 100, 100,
				   100, 100, 100, 100, 100, 100, 100, 100,
				   100, 100, 100, 100, 100, 100, 100, 100,
				   100, 100, 100, 100, 100, 100, 100, 3000, 0};

/* Take the lower 16 bits and make a pattern of them, MSB first */
static void panic_create_pattern(led_pattern *pattern, unsigned int reason)
{
	int i;
	for (i = 0; i < 16; i++) {
		if (reason & (1<<(15-i))) {
			pattern[2*i] = 400;
			pattern[2*i+1] = 100;
		} else {
			pattern[2*i] = 100;
			pattern[2*i+1] = 400;
		}
		if ((i % 4) == 3)
			pattern[2*i+1] += 500;
		if (i == 15)
			pattern[2*i+1] += 2500;
	}
}

void panic(unsigned int reason)
{
	/*
	 * We may one day be able to do something with the reason, like emit
	 * a final deathbed confession. So we'll provide the reasons in the
	 * caller and just ignore them for now.
	 */
	(void)reason;

	motor_kill();

	panic_create_pattern(led_pattern_panic, reason);

	led_set_pattern(led_pattern_panic);

	/* Wait for the inevitable plunge to the death */
	for (;;)
		led_update();
}
