/* watchdog.c */

#include "watchdog.h"
#include "panic.h"
#include "timer.h"

/* There are two watchdogs to worry about. The hardware one, and watchdogs
   to make sure that critical parts of the software are running.
 */

/*
 * This is about 10 times round the main loop. If we haven't had a kick by
 * now, something's gone horribly wrong.
 */

#define WATCHDOG_TIMEOUT (100 * TIMER0_MS)

static unsigned int watchdog_last_seen[WATCHDOG_MODULES];

void watchdog_kick(unsigned int module)
{
	if (module >= WATCHDOG_MODULES)
		return;
	watchdog_last_seen[module] = timer_read();
}

void watchdog_check(void)
{
	unsigned int time = timer_read();
	int i;

	/* XXX not yet */
/*	return; */
	for (i = 0; i < WATCHDOG_MODULES; i++) {
		if ((signed int)(watchdog_last_seen[i] + WATCHDOG_TIMEOUT
					- time) < 0) {
			panic(PANIC_WATCHDOG_TIMEOUT + i);
		}
	}
}

void init_watchdog(void)
{
	unsigned int time = timer_read();
	int i;

	for (i = 0; i < WATCHDOG_MODULES; i++) {
		watchdog_last_seen[i] = time;
	}
}
