/* main.c */

#include <signal.h>
#include <stdlib.h>
#include <err.h>
#include "vm.h"
#include "dmx.h"
#include "midi.h"
#include "beatdetect.h"
#include "mouse.h"

void finish(void)
{
	dmx_close();
	midi_close();
	beatdetect_close();
	exit(0);
}

void sigint_handler(int signal)
{
	finish();
}

int main(int argc, char *argv[])
{
	argv++;
	argc--;
	if (argc != 1)
		errx(1, "Usage: lsi <filename>");
	vm_init();
	vm_load(argv[0]);
	signal(SIGINT, sigint_handler);
	midi_init();
	dmx_init();
	beatdetect_init();
	mouse_init();
	vm_spawn("main");
	vm_run();
	finish();
	return 0;
}
