/* mem.c */

#include <stdio.h>
#include <stdlib.h>
#include <err.h>

void *safe_malloc(size_t size)
{
	void *mem;

	mem = malloc(size);
	if (mem == NULL)
		err(EXIT_FAILURE, "Failed to malloc %d bytes", size);
//	printf("Allocated %d bytes at %p\n", size, mem);
	return mem;
}

void *safe_realloc(void *ptr, size_t size)
{
	void *mem;

	mem = realloc(ptr, size);
	if (mem == NULL)
		err(EXIT_FAILURE, "Failed to relloc %d bytes", size);
	return mem;
}
