#ifndef __I2C_H
#define __I2C_H

#include "types.h"

#define I2C_IN_PROGRESS 0
#define I2C_SUCCESS     1
#define I2C_FAIL        2

typedef int i2c_result;

struct i2c_transaction {
	int address;	/* i2c first byte, including address and r/w flag */
	int bytes;	/* number of bytes to read or write */
	unsigned char *data;	/* pointer to the data */
	i2c_result *result; /* pointer to store the result */
	struct i2c_transaction *next; /* NULL or next transaction */
};


void init_i2c(void);
int i2c_conreg(void);
int i2c_statreg(void);
bool i2c_start_transaction(struct i2c_transaction *t);
bool i2c_busy(void);

#endif /* __I2C_H */
