/* test-therm.c */

#include "common.h"
#include "therm.h"

int32_t extend24(int32_t n)
{
    if (n & 0x00800000) {
	return n | (~0 & 0xff000000);
    }
    return n;
}

temp_t therm_temp(void)
{
//    return extend24(0xf06000);
    return 3932;
#if 0
    return 0x078000;
    return 0x064f00;
    return 0x52d000;
#endif
}

temp_t therm_coldtemp(void)
{
    return 2987;
#if 0
    return 0x19800;
#endif
}

uint8_t therm_fault(void)
{
    return 0;
}

temp_t therm_reduce(int32_t temp)
{
    temp = (temp * 10) / 4096;
    temp += 2732;
    if (temp < 0)
        temp = 0;
    if (temp > 65535)
        temp = 65535;

    return (temp_t) temp;
}

