/* test-display.c */

#include <stdlib.h>
#include <ncurses.h>

#include "types.h"

unsigned int curpos;

void display_cleanup(void)
{
    endwin();
}

void display_data(uint8_t len, uint8_t *data)
{
    /* can't do anything with this graphics */
}

void display_init(void)
{
    initscr();
    noecho();
    atexit(display_cleanup);
}

void display_setposition(char col, char row)
{
    move(row, col/6);
    curpos = col/6;
    //printf("Position set to row %d, col %d\n", row, col/6);
}

void display_setinverse(bool on)
{
    if (on)
	attron(A_REVERSE);
    else
	attroff(A_REVERSE);
    //printf("Inverse set to %s\n", on?"on":"off");
}

void display_putchar(char c)
{
    printw("%c", c);
    refresh();
    curpos++;
    //printf("Put character %c\n", c);
}

void display_putstr(char *s)
{
    while (*s)
	display_putchar(*(s++));
}

void display_putstr_P(const char *s)
{
    display_putstr((char *)s);
}

void display_clearline(void)
{
    while (curpos < 21) {
	display_putchar(' ');
    }
    //printf("Cleared line\n");
}
