/* i2c.c */

#include "common.h"
#include "SDL.h"
#include "SDL_gfxPrimitives.h"


#define WHITE 0xffffffff
#define BLACK 0x000000ff

uint8_t i2c_xor;
uint8_t page;
uint8_t col;


extern SDL_Surface *screen;

void i2c_init(void)
{
}

void i2c_set_xor(char xor)
{
    i2c_xor = xor;
}

bool i2c_write(char address, char prefix, char bytes, char *data)
{
    uint8_t i, j;

    switch ((uint8_t) prefix) {
    case 0x80:
	switch (data[0] & 0xf0) {
	case 0xb0:
	    page = data[0] & 0xf;
	    break;
	case 0x00:
	    col = (col & ~0xf) + (data[0] & 0xf);
	    break;
	case 0x10:
	    col = (col & 0xf) + ((data[0] & 0xf) << 4);
	    break;
	}
	break;
    case 0x40:
	for (i = 0; i < bytes; i++) {
	    uint8_t byte = data[i] ^ i2c_xor;
	    for (j = 0; j < 8; j++) {
		pixelColor(screen, col, page*8 + j, (byte & 1)?WHITE:BLACK);
		byte = byte >> 1;
	    }
	    col++;
	    if (col > 127)
		col = 0;
	}
	break;
    }


    return TRUE;
}

