/* beep.c */

#include <avr/io.h>

#include "common.h"

#define DDR_BEEP DDRB
#define PORT_BEEP PORTB

#define PIN_BEEP 1

void beep_on(void)
{
    TIMSK1 = 0;
    TCCR1A = (1<<COM1A0);
    TCCR1B = (1<<CS10) | (1<<WGM12); /* clkIO / 1, CTC mode */
    DDR_BEEP |= (1<<PIN_BEEP);
    OCR1A = 1000;
}

void beep_off(void)
{
    DDR_BEEP &= ~(1<<PIN_BEEP);
}
