/* spi.c */

#include <avr/io.h>

#include "common.h"

#define DDR_SPI DDRB
#define PORT_SPI PORTB

#define PIN_MOSI 3
#define PIN_SCK 5
#define PIN_SS 2

void spi_init(void)
{
    /* Set MOSI, SCK and SS output */
    PORT_SPI |= (1<<PIN_SS);
    DDR_SPI |= (1<<PIN_MOSI) | (1<<PIN_SCK) | (1<<PIN_SS);

    /* Enable SPI, Master, set clock rate fck/16 */
//    SPCR = (1<<SPE) | (1<<MSTR) | (1<<SPR0);

//    SPCR = (1<<SPE) | (1<<MSTR) | /*(1<<SPR1) |*/ (1<<SPR0) | (1<<CPHA) | (1<<CPOL);
    SPCR = (1<<SPE) | (1<<MSTR) | (1<<SPR1) | (1<<SPR0) | (1<<CPHA) | (1<<CPOL);

}

void spi_start(void)
{
    PORT_SPI &= ~(1<<PIN_SS);
}

void spi_stop(void)
{
    PORT_SPI |= (1<<PIN_SS);
}

char spi_txrxbyte(char data)
{
    /* Start transmission */
    SPDR = data;

    /* Wait for transmission complete */
    while (!(SPSR & (1<<SPIF)))
	;

    /* Return byte received */
    return SPDR;
}

char spi_rxbyte(void)
{
    return spi_txrxbyte(0);
}
