/* timer.h */

#ifndef _TIMER_H_
#define _TIMER_H_

#include "common.h"

#define CLOCK_FREQ 4000000
#define PRESCALER 256
#define TIMER_MAX 125

/* Careful to make this an integer */
#define TICKS_PER_SECOND (CLOCK_FREQ / (TIMER_MAX * PRESCALER))

extern uint8_t button;

extern volatile uint8_t output0;
extern volatile uint8_t output1;

extern volatile uint32_t seconds;

void timer_init(void);

#endif
