/* profile.h */

#ifndef _PROFILE_H_
#define _PROFILE_H_

#include "common.h"

void set_profile_temperature(temp_t temp);
temp_t get_profile_temperature(uint8_t row);
uint32_t profile_time(uint8_t line);
temp_t temperature_at_time(uint32_t time);
void set_profile_time(uint8_t row, uint16_t time, uint8_t time_units);
uint16_t profile_get_time(uint8_t row);
uint8_t profile_get_time_units(uint8_t row);
void profile_select(uint8_t n);
void profile_save(void);

typedef struct profile_line {
    uint16_t temperature; /* store degrees C * 10 reference to absolute zero */
    unsigned int time:14;
    unsigned int time_units:2;
} profile_line_t;

#define PROFILE_NAME_LENGTH 6

typedef struct profile {
    char name[PROFILE_NAME_LENGTH];
    uint16_t start_temp;
    profile_line_t lines[6];
} profile_t;

extern profile_t *profile_p;

#endif
