/* menu.h */

#ifndef _MENU_H_
#define _MENU_H_

#include "common.h"

void menu_init(void);
void menu_poll(void);
void menu_new_data(void);

/* This stuff is for fields.c only, for now */
#include "fields.h"
extern field_t fields[];
char menu_getchar(uint8_t col);
typedef void (*field_handler)(uint8_t row);
typedef struct menu {
    PGM_P const *text;
    uint8_t first_line;
    uint8_t last_line;
    field_handler get_field;
    field_handler put_field;
} menu_t;
extern menu_t *menu_current_p;
int32_t temperature_from_kelvin(temp_t source);
temp_t temperature_to_kelvin(int32_t source);
extern uint8_t field_row;
extern uint8_t current_profile;

#endif
