/* fields.h */

#ifndef _FIELDS_H_
#define _FIELDS_H_

#include "common.h"
#include "avr/pgmspace.h"

#define DISPLAY_CHARS 21

extern uint8_t field_values[DISPLAY_CHARS];

typedef struct field {
    PGM_P const *display;
    uint8_t display_entries;
    uint8_t length;
} field_t;

//#define field(c) fields[((uint8_t)(c) & (uint8_t)15)-1]

//#define field_length(c) (field(c).length)

#define FIELD_SIGN_NEGATIVE 0
#define FIELD_SIGN_POSITIVE 1

uint8_t field_length(char c);
bool field_is_text(char c);
PGM_P field_text(char c, uint8_t n);
uint8_t field_display_entries(char c);
bool is_field(char c);
bool is_editable(char c);
PGM_P get_string(PGM_P const *addr);
uint8_t find_field(uint8_t n);
uint8_t find_field_length_by_place(uint8_t index);
uint8_t find_field_length(uint8_t index);
uint8_t find_field_number(uint8_t index);
uint8_t find_editable_field(uint8_t index, bool left);
void write_field_enum(uint8_t field, uint8_t val);
uint8_t read_field_enum(uint8_t field);
uint16_t read_field_uint16(uint8_t field);
void write_field_uint16(uint8_t field, uint16_t val);

#define read_field_uint8(x) read_field_uint16(x)
#define write_field_uint8(x, y) write_field_uint16(x, y)

void write_field_integer_part(uint8_t field, int32_t val);
void write_field_fractional_part(uint8_t field, int32_t val);
int32_t round_dp(int32_t n, uint8_t dp);
uint32_t read_field_fracint(int8_t index, bool frac);
void write_field_fracint(uint8_t index, bool sign, bool frac, int32_t val);
void write_field_temperature(uint8_t index, bool frac, temp_t k_temp);

#endif
