/* test-graphics.c */

#include "SDL.h"
#include "SDL_gfxPrimitives.h"
#include "menu.h"

#include "common.h"

SDL_Surface *screen;

SDL_Event event;

#define WHITE 0xffffffff

int button = 0;

uint32_t seconds;
uint8_t output0;

void beep_off(void)
{
}

int main(int argc, char *argv[]) {
    SDL_Init(SDL_INIT_VIDEO);

    screen = SDL_SetVideoMode(128, 64, 16, SDL_SWSURFACE);

    SDL_WM_SetCaption("Reflow oven controller", "Reflow oven controller");

    bool done=FALSE;

    menu_init();

    while(!done) {
	while(SDL_PollEvent(&event)) {
	    if (event.type == SDL_QUIT) {
		done=TRUE;
	    }
	    if (event.type == SDL_KEYDOWN) {
                switch(event.key.keysym.sym) {
		case SDLK_UP:
		    button = 1;
		    break;
		case SDLK_DOWN:
		    button = 2;
		    break;
		case SDLK_LEFT:
		    button = 4;
		    break;
		case SDLK_RIGHT:
		    button = 3;
		    break;
		case SDLK_q:
		    done = TRUE;
		    break;
		default:
		    break;
		}
	    }
	    menu_poll();
	    SDL_Flip(screen);
	}
    }

    SDL_Quit();

    return 0;
}

