/* button.c */

#include <avr/io.h>
#include <avr/interrupt.h>
#include "common.h"

uint8_t bounce_timer;
uint8_t button;

#define BOUNCE_TIMER_RESET 10

void button_init(void)
{
    bounce_timer = 0;
    button = 0;
}

ISR(TIMER2_vect)
{
    uint8_t port = PORTD;
    uint8_t old_button;
    port = (~port >> 4);
    if (bounce_timer)
	bounce_timer--;
    else
	if (port)
	    button = 1 + ctz(port);
	else
	    button = 0;

    if (button != old_button)
	bounce_timer = BOUNCE_TIMER_RESET;
}
