/* sensors.h */

#ifndef __SENSORS_H
#define __SENSORS_H

#include "types.h"

/* functions to be called from above */
bool sensors_init(void);
bool sensors_start_sample(void);
void sensors_dump(void);

/* functions to be called from below */
void sensors_sample_done(void);
/* x = roll, y = pitch, z = yaw */
void sensors_write_gyro_data(vec3f gyro_data);
void sensors_write_accel_data(vec3f accel_data);
void sensors_write_temp_data(float temp);
void sensors_start_zero(void);

#endif /* __SENSORS_H */
